//
//  GSFontCheckerProtocol.h
//  GlyphsCore
//
//  Created by Georg Seifert on 15.03.18.
//  Copyright © 2018 schriftgestaltung.de. All rights reserved.
//

#import <Foundation/Foundation.h>

@class GSFont;

extern NSString *GSFontCheckerItemTitleKey;
extern NSString *GSFontCheckerItemIsGroupKey;
extern NSString *GSFontCheckerItemCheckedKey;
extern NSString *GSFontCheckerItemHandlerKey;
extern NSString *GSFontCheckerItemLayerKey;
extern NSString *GSFontCheckerItemGlyphsKey;
extern NSString *GSFontCheckerItemFirstActionTitleKey;
extern NSString *GSFontCheckerItemSecondActionTitleKey;

@protocol GSFontCheckerProtocol <NSObject>

- (NSArray *)checkFont:(GSFont *)font error:(out NSError **)error;

- (NSDictionary *)validateFont:(GSFont *)font error:(out NSError **)error;

- (BOOL)processValidatorResult:result error:(out NSError **)error;

@optional

/// only implement if Ture
- (BOOL)runOnVersionChangeOnly;
@end
